/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml.strip;

import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.xml.InvalidXmlException;
import cz.insophy.inplan.xml.RobustSuperplanLoadResult;
import cz.insophy.inplan.xml.ShopSerializer;
import cz.insophy.inplan.xml.SuperplanSerializationException;
import cz.insophy.inplan.xml.SuperplanSerializer;
import cz.insophy.inplan.xml.XmlSource;
import cz.insophy.inplan.xml.strip.ActivePartsParser;
import java.io.IOException;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class StrippedSuperplanReader {
    public static Superplan loadFromXml(ByteSource confXml, ByteSource planXml) throws InvalidXmlException, SuperplanSerializationException {
        ShopConfiguration fullConf;
        try {
            fullConf = ShopSerializer.loadFromXml(confXml.openStream());
        }
        catch (IOException e) {
            throw new InvalidXmlException("Cannot open shop configuration XML.", e);
        }
        Set<Material> usedMatprods = StrippedSuperplanReader.loadUsedMatprods(planXml, fullConf);
        ShopConfiguration strippedConf = StrippedSuperplanReader.createStrippedConfiguration(fullConf, usedMatprods);
        usedMatprods = null;
        fullConf = null;
        try {
            RobustSuperplanLoadResult result = SuperplanSerializer.robustLoadFromXml(XmlSource.create(planXml.openStream()), strippedConf, true);
            return result.getSuperplan();
        }
        catch (IOException e) {
            throw new SuperplanSerializationException("Cannot open plan XML for the 2nd time.", e);
        }
    }

    private static Set<Material> loadUsedMatprods(ByteSource planXml, ShopConfiguration fullConf) throws SuperplanSerializationException {
        Set<Material> usedMatprods;
        try {
            ActivePartsParser app = new ActivePartsParser(fullConf);
            app.parse(planXml.openStream());
            usedMatprods = app.getUsedMatprods();
        }
        catch (IOException e) {
            throw new SuperplanSerializationException("Cannot open superplan XML.", e);
        }
        catch (SAXException e) {
            throw new SuperplanSerializationException("Cannot parse superplan XML.", e);
        }
        return usedMatprods;
    }

    private static ShopConfiguration createStrippedConfiguration(ShopConfiguration fullConf, Set<Material> usedMatprods) throws InvalidXmlException {
        ShopSerializer.ShopConfWriter scw = new ShopSerializer.ShopConfWriter(fullConf, usedMatprods);
        FileBackedOutputStream fbos = new FileBackedOutputStream(0x1000000);
        try {
            scw.writeConfiguration(fbos);
            ShopConfiguration shopConfiguration = ShopSerializer.loadFromXml(fbos.asByteSource().openStream());
            return shopConfiguration;
        }
        catch (XMLStreamException e) {
            throw new InvalidXmlException("Cannot read temporary conf.", e);
        }
        catch (IOException e) {
            throw new InvalidXmlException("Cannot write temporary conf file.", e);
        }
        finally {
            try {
                fbos.reset();
            }
            catch (IOException iOException) {}
        }
    }
}

